#!/usr/bin/php
<?php
// Twitter Status Update via Oauth
// By Scott Wilcox (v0.1) http://dor.ky
//
// This script is a basic script that will post an update to 
// Twitter using OAuth. (Basic Auth is being deprecated at 
// the moment).

// This script uses the fantastic twitter-async library
// which was created by jmathai. You can get the latest news 
// and updates for that over at Github using the following url 
// http://github.com/jmathai/twitter-async
require "lib/EpiCurl.php";
require "lib/EpiOAuth.php";
require "lib/EpiTwitter.php";

// You need to fetch these OAuth tokens and save them for use
// within the OAuth calls. To get these values you will need
// to create a new 'app' at http://dev.twitter.com/apps
//
// You can find CONSUMER_KEY and CONSUMER_SECRET on your apps
// 'Application Details' page, and you can find USER_TOKEN and
// USER_SECRET on the 'My Access Token' page.
define(CONSUMER_KEY,"Replace with your Consumer Key");
define(CONSUMER_SECRET,"Replace with your Consumer Secret");
define(USER_TOKEN,"Replace with 'My Access Token' Oauth token");
define(USER_SECRET,"Replace with 'My Access Token' Oauth secret");

// If there was a command line argument passed, we can use that as
// the status update text, else print an error out
if ($_SERVER["argv"][1]) {
	// Format text as utf8 and chomp at 140 chars
	$text = utf8_encode(substr($_SERVER["argv"][1],0,140));
	
	$twitterObj = new EpiTwitter(CONSUMER_KEY,CONSUMER_SECRET,USER_TOKEN,USER_SECRET);
	$x = $twitterObj->post_statusesUpdate(array('status' => $text));
	if ($x->id) {
		echo "Tweet Posted: ".$x->id."\n";
	} else {
		echo "Error Posting Tweet\n";	
	}	
} else {
	echo "Usage: ./twitter.php 'My status update goes here'\n";
}
?>